<?php
/* --------------------------------------------------------------
 CommandDispatcherRegistration.php 2020-04-06
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace Gambio\Core\Application\Kernel\Bootstrapper;

use Gambio\Core\Application\Application;
use Gambio\Core\Application\Kernel\AbstractBootstrapper;
use Gambio\Core\Command\CommandDispatcherServiceProvider;

/**
 * Class CommandDispatcherRegistration
 * @package Gambio\Core\Application\Kernel\Bootstrapper
 */
class CommandDispatcherRegistration extends AbstractBootstrapper
{
    /**
     * @inheritDoc
     */
    public function boot(Application $application): void
    {
        $serviceProvider = new CommandDispatcherServiceProvider($application);
        $application->addServiceProvider($serviceProvider->toLeagueInterface());
    }
}